import { View, FlatList, StyleSheet } from 'react-native';
import React from 'react';
import SkeletonElement from '../../../SkeletonElement';
import dpr from '../../../../../screens/Utilities/CustomStyleAttribute/dpr';
import { MyRefundStyle } from '../../../../../screens/Profile/MyRefund/MyRefundStyle';

const RenderItem = ({ item }) => {
    return (
        <>
            <View style={MyRefundStyle.lastRefund}>
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 280)} />
                    <View style={styles.marginTop(14)}>
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(14, 240)} />
                        <SkeletonElement wrapperStyle={styles.skeletonWrapper(14, 190)} />
                    </View>
                </View>
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(14, 300)} />
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(60, 300)}/>
                </View>
                <View style={styles.skeletonElementContainerStyle}>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapperStyle1}/>
                </View>
            </View>
            <View
                style={[
                    MyRefundStyle.lastRefund,
                    styles.marginTop(18),
                ]}
            >
                <SkeletonElement wrapperStyle={styles.skeletonWrapper(14, 80)} />
            </View>
            <View
                style={[
                    MyRefundStyle.lastRefund,
                    styles.skeletonElementContainerStyle2
                ]}
            >
                <SkeletonElement  wrapperStyle={styles.skeletonWrapperStyle2} />
                <View>
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(14, 280)} />
                    <SkeletonElement wrapperStyle={styles.skeletonWrapper(14, 280)} />
                </View>
                <View>
                    <SkeletonElement  wrapperStyle={styles.skeletonWrapper(40, 300)} />
                </View>
            </View>
        </>
    );
};
const MyRefundSkeleton = () => {
    return (
        <View>
            <FlatList
                data={[1]}
                renderItem={({ item }) => <RenderItem item={item} />}
                keyExtractor={(_, i) => `key-${i}`}
                showsVerticalScrollIndicator={false}
            />
        </View>
    );
};

export default MyRefundSkeleton;

const styles = StyleSheet.create({
    skeletonWrapper: (height, minusWidth) => ({
        height: dpr(height),
        width: dpr('wf') - dpr(minusWidth),
    }),
    marginTop: (value) => ({
        marginTop: dpr(value),
    }),
    skeletonElementContainerStyle: {
        marginVertical: dpr(10),
    },
    skeletonElementContainerStyle2: {
        marginTop: dpr(18),
        alignItems: 'center',
    },
    skeletonWrapperStyle1:{
        height: dpr(12),
    },
    skeletonWrapperStyle2: {
        height: dpr(80),
        width: dpr(80),
    },
});
